//------------------------------------------------------------------------------
// File: BecomeCivilian.cs
// State node which transitions any object to a civilian object
//------------------------------------------------------------------------------

////////////////////////////////////////////////////////////////////////////////
//! Called when node is entered
//! \param %cmpAI AI component object
////////////////////////////////////////////////////////////////////////////////
function AISMN_BecomeCivilian::OnEnter(%this, %cmpAI)
{   
   %object = GetThisObject(%cmpAI);
   
   // Reset the AI
   %object.setAI("com_settler");
   
   // Clear drunk state and reset happiness
   RestoreLostHappinessFromDrunk(%cmpAI);
   
   // Reset character outfit
   RestoreCharacterOutfit(%cmpAI);
   
   // Restore monitors
   %cmpAI.enableMonitors();
   
   // Stop character from moving if it is
   if(IsFollowingPath(%cmpAI)) {
      StopMoving(%cmpAI);
      %object.playThread( 0, "root");
   }
   return;
}

////////////////////////////////////////////////////////////////////////////////
//! Called when node is exited
//! \param %cmpAI AI component object
////////////////////////////////////////////////////////////////////////////////
function AISMN_BecomeCivilian::OnExit(%this, %cmpAI)
{
   return;
}

////////////////////////////////////////////////////////////////////////////////
//! Called when node is updated
//! \param %cmpAI AI component object
////////////////////////////////////////////////////////////////////////////////
function AISMN_BecomeCivilian::Update(%this, %cmpAI)
{   
   ReturnValue(%cmpAI,0);
   return;
}

// End BecomeCivilian.cs